<?php
require "../functions/sortArrays.php";
abstract class Api
{
   public $apiName = ""; //users

   protected $method = ""; //GET|POST|PUT|DELETE

   public $requestUri = [];
   public $requestParams = [];
   protected $action = ""; //Название метод для выполнения

   public function __construct()
   {
      //Массив GET параметров разделенных слешем
      $this->requestUri = explode("/", trim($_SERVER["REQUEST_URI"], "/"));
      $this->requestParams = $_REQUEST;
      //Определение метода запроса
      $this->method = $_SERVER["REQUEST_METHOD"];
      if ($this->method == "POST" && array_key_exists("HTTP_X_HTTP_METHOD", $_SERVER)) {
         if ($_SERVER["HTTP_X_HTTP_METHOD"] == "DELETE") {
            $this->method = "DELETE";
         } elseif ($_SERVER["HTTP_X_HTTP_METHOD"] == "PUT") {
            $this->method = "PUT";
         } else {
            throw new Exception("Unexpected Header");
         }
      }
   }

   public function run()
   {
      //Первые 2 элемента массива URI должны быть "api" и название таблицы
      if (array_shift($this->requestUri) !== "api" || array_shift($this->requestUri) !== $this->apiName) {
         throw new RuntimeException("API Not Found", 404);
      }
      //Определение действия для обработки
      $this->action = $this->getMethod();
      //Если метод(действие) определен в дочернем классе API
      if (method_exists($this, $this->action)) {
         return $this->{$this->action}();
      } else {
         throw new RuntimeException("Invalid Method", 405);
      }
   }
   protected function getMethod()
   {
      $method = $this->method;
      switch ($method) {
         case "GET":
            return "getAction";
            break;
         case "POST":
            return "createAction";
            break;
         case "PUT":
            return "updateAction";
            break;
         case "PATCH":
            return "changeAction";
            break;
         case "DELETE":
            return "deleteAction";
            break;
         default:
            return null;
      }
   }

   abstract protected function getAction();
   abstract protected function createAction();
   abstract protected function updateAction();
   abstract protected function changeAction();
   abstract protected function deleteAction();
}
function getParams()
{
   $url = $_SERVER["REQUEST_URI"];
   if (isset($url)) {
      $params = explode("/", $url);
      $id = null;
      $requestUrl = null;
      $explode = null;
      $count = count($params) - 1;
      if (count($params) === 5) {
         $requestUrl = $params[$count];
         return [$requestUrl];
      } elseif (count($params) === 6) {
         if (is_numeric($params[$count])) {
            $id = $params[$count];
            $requestUrl = $params[$count - 1];
            return [$requestUrl, $id];
         } else {
            $requestUrl = $params[$count];
            return [$requestUrl];
         }
      } elseif (count($params) === 7) {
         if (is_numeric($params[$count - 1])) {
            $id = $params[$count - 1];
            $requestUrl = $params[$count];
            return [$requestUrl, $id];
         } else {
            $requestUrl = $params[$count];
            return [$requestUrl];
         }
      } else {
         return null;
      }
   } else {
      return null;
   }
}
